package ru.yandex.mail.so.sarlacc.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveIntegerValidator;
import ru.yandex.parser.string.PositiveLongValidator;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigBuilder;

public abstract class AbstractSarlaccConfigBuilder<T extends AbstractSarlaccConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T> implements SarlaccConfig
{
    private HttpHostConfigBuilder producerAsyncClientConfig;
    private String indexingQueueName;
    private StaterConfigBuilder indexSearchStaterConfig;
    private long searchTimeout;
    private int searchBackendShardsNumber;
    private ShinglersConfig shinglersConfig;

    protected AbstractSarlaccConfigBuilder(final SarlaccConfig config) {
        super(config);
        if (config.producerAsyncClientConfig() != null) {
            producerAsyncClientConfig(config.producerAsyncClientConfig());
        } else {
            producerAsyncClientConfig(config.producerClientConfig());
        }
        indexingQueueName(config.indexingQueueName());
        indexSearchStaterConfig(config.indexSearchStaterConfig());
        searchTimeout(config.searchTimeout());
        searchBackendShardsNumber(config.searchBackendShardsNumber());
        shinglersConfig(config.shinglersConfig());
    }

    protected AbstractSarlaccConfigBuilder(final IniConfig config, final SarlaccConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig sarlaccConfig = config.section("sarlacc");
        indexingQueueName = sarlaccConfig.get(
            "indexing-queue-name",
            defaults.indexingQueueName(),
            NonEmptyValidator.INSTANCE);
        if (indexingQueueName != null) {
            producerAsyncClientConfig =
                new HttpHostConfigBuilder(
                    config.section("producer-async-client"),
                    defaults.producerAsyncClientConfig());
        }
        indexSearchStaterConfig =
            new StaterConfigBuilder(config.section("index-search-stat"), defaults.indexSearchStaterConfig());
        searchTimeout = sarlaccConfig.get("search-timeout", defaults.searchTimeout(), PositiveLongValidator.INSTANCE);
        searchBackendShardsNumber = sarlaccConfig.get(
            "search-backend-shards-number",
            defaults.searchBackendShardsNumber(),
            PositiveIntegerValidator.INSTANCE);
        shinglersConfig = new ShinglersConfigBuilder(
            config.section(ShinglersConfigBuilder.SECTION),
            defaults.shinglersConfig());
    }

    @Override
    public HttpHostConfigBuilder producerAsyncClientConfig() {
        return this.producerAsyncClientConfig;
    }

    public T producerAsyncClientConfig(final HttpHostConfig producerAsyncClientConfig) {
        this.producerAsyncClientConfig = new HttpHostConfigBuilder(producerAsyncClientConfig);
        return this.self();
    }

    @Override
    public String indexingQueueName() {
        return indexingQueueName;
    }

    public T indexingQueueName(final String indexingQueueName) {
        this.indexingQueueName = indexingQueueName;
        return self();
    }

    @Override
    public StaterConfig indexSearchStaterConfig() {
        return indexSearchStaterConfig;
    }

    public T indexSearchStaterConfig(final StaterConfig indexSearchStaterConfig) {
        this.indexSearchStaterConfig = new StaterConfigBuilder(indexSearchStaterConfig);
        return self();
    }

    @Override
    public long searchTimeout() {
        return searchTimeout;
    }

    public T searchTimeout(final long searchTimeout) {
        this.searchTimeout = searchTimeout;
        return self();
    }

    @Override
    public int searchBackendShardsNumber() {
        return searchBackendShardsNumber;
    }

    public T searchBackendShardsNumber(final int searchBackendShardsNumber) {
        this.searchBackendShardsNumber = searchBackendShardsNumber;
        return self();
    }

    @Override
    public ShinglersConfig shinglersConfig() {
        return shinglersConfig;
    }

    public T shinglersConfig(final ShinglersConfig shinglersConfig) {
        this.shinglersConfig = new ShinglersConfigBuilder(shinglersConfig);
        return self();
    }
}
