package ru.yandex.mail.so.sarlacc.config;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.function.StringProcessor;
import ru.yandex.mail.so.sarlacc.ShinglerType;
import ru.yandex.mail.so.sarlacc.ShinglesPeriod;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.stater.AbstractStaterConfigBuilder;
import ru.yandex.stater.StaterConfigDefaults;

public abstract class AbstractShinglerConfigBuilder<T extends AbstractShinglerConfigBuilder<T>>
    extends AbstractStaterConfigBuilder<T>
    implements ConfigBuilder<T>, ShinglerConfig
{
    private static final StringProcessor<List<ShinglesPeriod>, RuntimeException> commaSeparatedShinglesTtlParser =
        new StringProcessor<>(new CollectionParser<>(new ShinglesPeriod.Parser(), ArrayList::new));

    private ShinglerType shinglerType;
    private List<ShinglesPeriod> shinglesPeriods;

    protected AbstractShinglerConfigBuilder(final ShinglerConfig config) {
        super(config);
        shinglerType = config.type();
        shinglesPeriods = new ArrayList<>(config.shinglesPeriod());
    }

    protected AbstractShinglerConfigBuilder(final IniConfig config, final ShinglerConfig defaults)
        throws ConfigException
    {
        super(config.section("stat"), defaults == null ? StaterConfigDefaults.INSTANCE : defaults);
        shinglerType = config.get("type", null, new EnumParser<>(ShinglerType.class));
        String shinglesPeriod = config.getOrNull("periods");
        shinglesPeriods = shinglesPeriod == null ? List.of() : commaSeparatedShinglesTtlParser.process(shinglesPeriod);
    }

    @Override
    public ShinglerType type() {
        return shinglerType;
    }

    public T type(final ShinglerType shinglerType) {
        this.shinglerType = shinglerType;
        return self();
    }

    @Override
    public List<ShinglesPeriod> shinglesPeriod() {
        return shinglesPeriods;
    }

    public T shinglesTtl(final List<ShinglesPeriod> shinglesPeriods) {
        this.shinglesPeriods = shinglesPeriods;
        return self();
    }
}
