package ru.yandex.mail.so.sarlacc.config;

import java.util.Map;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.request.RequestPatternParser;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractShinglersConfigBuilder<T extends AbstractShinglersConfigBuilder<T>>
    implements ConfigBuilder<T>, ShinglersConfig
{
    public static final String SECTION = "shingler";

    private static final GenericFunction<ShinglerConfig, ShinglerConfigBuilder, RuntimeException>
        TRANSFORMER = config -> {
            if (config == null) {
                return null;
            } else {
                return new ShinglerConfigBuilder(config);
            }
        };

    private PatternMap<RequestInfo, ShinglerConfigBuilder> shinglers;

    protected AbstractShinglersConfigBuilder() {
        this(ShinglersConfigDefaults.INSTANCE);
    }

    protected AbstractShinglersConfigBuilder(final ShinglersConfig config)
    {
        shinglers = config.shinglers().transform(TRANSFORMER);
    }

    protected AbstractShinglersConfigBuilder(final IniConfig config) throws ConfigException
    {
        this(config, ShinglersConfigDefaults.INSTANCE);
    }

    protected AbstractShinglersConfigBuilder(final IniConfig config, final ShinglersConfig defaults)
        throws ConfigException
    {
        shinglers = loadLogRecordsHandlers(config, defaults);
        asterisk(new ShinglerConfigBuilder());
    }

    public static PatternMap<RequestInfo, ShinglerConfigBuilder> loadLogRecordsHandlers(
        final IniConfig section,
        final ShinglersConfig defaults)
        throws ConfigException
    {
        PatternMap<RequestInfo, ShinglerConfigBuilder> shinglers = new PatternMap<>(
            new ShinglerConfigBuilder(section, defaults.shinglers().asterisk()));
        for (Map.Entry<String, IniConfig> entry : section.sections().entrySet()) {
            String subsection = entry.getKey();
            if (subsection.indexOf('/') != -1 || subsection.indexOf(':') != -1 || subsection.indexOf('*') != -1) {
                Pattern<RequestInfo> pattern = RequestPatternParser.INSTANCE.apply(subsection);
                shinglers.put(
                    pattern,
                    new ShinglerConfigBuilder(entry.getValue(), defaults.shinglers().get(pattern)));
            }
        }
        return shinglers;
    }

    @Override
    public PatternMap<RequestInfo, ShinglerConfigBuilder> shinglers() {
        return shinglers;
    }

    public T shinglers(final PatternMap<RequestInfo, ? extends ShinglerConfigBuilder> shinglers) {
        this.shinglers = shinglers.transform(TRANSFORMER);
        return self();
    }

    public T shingler(final Pattern<RequestInfo> pattern, final ShinglerConfigBuilder shingler) {
        shinglers.put(pattern, shingler);
        return self();
    }

    public T asterisk(final ShinglerConfigBuilder shingler) {
        shinglers.put(new Pattern<>("", true), shingler);
        return self();
    }

    public ImmutableShinglersConfig build() throws ConfigException {
        return new ImmutableShinglersConfig(this);
    }
}
