package ru.yandex.mail.so.sarlacc.config;

import java.io.IOException;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;
import ru.yandex.stater.ImmutableStaterConfig;

public class ImmutableSarlaccConfig extends ImmutableUniversalSearchProxyConfig implements SarlaccConfig {
    private final ImmutableHttpHostConfig producerAsyncClientConfig;
    private final String indexingQueueName;
    private final ImmutableStaterConfig indexSearchStaterConfig;
    private final long searchTimeout;
    private final int searchBackendShardsNumber;
    private final ImmutableShinglersConfig shinglersConfig;

    public ImmutableSarlaccConfig(final SarlaccConfig config) throws ConfigException, IOException {
        super(config);
        if (config.producerAsyncClientConfig() != null) {
            producerAsyncClientConfig = new ImmutableHttpHostConfig(config.producerAsyncClientConfig());
            indexingQueueName = config.indexingQueueName();
        } else {
            producerAsyncClientConfig = null;
            indexingQueueName = null;
        }
        if (producerClientConfig() == null) {
            throw new ConfigException("There are no parameters for producerClient in config");
        }
        indexSearchStaterConfig = new ImmutableStaterConfig(config.indexSearchStaterConfig());
        searchTimeout = config.searchTimeout();
        searchBackendShardsNumber = config.searchBackendShardsNumber();
        shinglersConfig = new ImmutableShinglersConfig(config.shinglersConfig());
    }

    @Override
    public ImmutableHttpHostConfig producerAsyncClientConfig() {
        return producerAsyncClientConfig;
    }

    @Override
    public String indexingQueueName() {
        return indexingQueueName;
    }

    @Override
    public ImmutableStaterConfig indexSearchStaterConfig() {
        return indexSearchStaterConfig;
    }

    @Override
    public long searchTimeout() {
        return searchTimeout;
    }

    @Override
    public int searchBackendShardsNumber() {
        return searchBackendShardsNumber;
    }

    @Override
    public ImmutableShinglersConfig shinglersConfig() {
        return shinglersConfig;
    }
}
