package ru.yandex.mail.so.sarlacc.config;

import java.util.Collections;
import java.util.List;

import ru.yandex.mail.so.sarlacc.ShinglerType;
import ru.yandex.mail.so.sarlacc.ShinglesPeriod;
import ru.yandex.stater.ImmutableStaterConfig;

public class ImmutableShinglerConfig extends ImmutableStaterConfig implements ShinglerConfig {
    private final ShinglerType shinglerType;
    private final List<ShinglesPeriod> shinglesPeriods;

    public ImmutableShinglerConfig(final ShinglerConfig config) {
        super(config);
        shinglerType = config.type();
        shinglesPeriods = Collections.unmodifiableList(config.shinglesPeriod());
    }

    @Override
    public ShinglerType type() {
        return shinglerType;
    }

    @Override
    public List<ShinglesPeriod> shinglesPeriod() {
        return shinglesPeriods;
    }
}
