package ru.yandex.mail.so.sarlacc.config;

import ru.yandex.collection.PatternMap;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.parser.config.ConfigException;

public class ImmutableShinglersConfig implements ShinglersConfig {
    private static final GenericFunction<ShinglerConfig, ImmutableShinglerConfig, ConfigException>
        TRANSFORMER = config -> {
            if (config == null) {
                return null;
            } else {
                return new ImmutableShinglerConfig(config);
            }
        };

    private final PatternMap<RequestInfo, ImmutableShinglerConfig> logRecordsHandlerConfigs;

    public ImmutableShinglersConfig(final ShinglersConfig config) throws ConfigException {
        logRecordsHandlerConfigs = config.shinglers().transform(TRANSFORMER);
    }

    @Override
    public PatternMap<RequestInfo, ImmutableShinglerConfig> shinglers() {
        return logRecordsHandlerConfigs;
    }
}
