package ru.yandex.mail.so.sarlacc.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;
import ru.yandex.stater.StaterConfig;

public interface SarlaccConfig extends UniversalSearchProxyConfig {
    /**
     * Get name of indexation queue
     *
     * @return name of indexation queue
     */
    String indexingQueueName();

    /**
     * Get number of shards in the search backend
     *
     * @return number of shards in the search backend
     */
    int searchBackendShardsNumber();

    /**
     * Get timeout for search requests
     *
     * @return timeout for search requests
     */
    long searchTimeout();

    /**
     * Get config for staters of search backend's index
     *
     * @return config for staters of search backend's index
     */
    StaterConfig indexSearchStaterConfig();

    /**
     * Get config for the producer's async clients
     *
     * @return config for the producer's async clients
     */
    HttpHostConfig producerAsyncClientConfig();

    /**
     * Get config for shinglers
     *
     * @return config for shinglers
     */
    ShinglersConfig shinglersConfig();
}
