package ru.yandex.mail.so.sarlacc.config;

import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class SarlaccConfigBuilder
        extends AbstractSarlaccConfigBuilder<SarlaccConfigBuilder> implements SarlaccConfig
{
    public SarlaccConfigBuilder() {
        super(SarlaccConfigDefaults.INSTANCE);
    }

    public SarlaccConfigBuilder(final SarlaccConfig config) {
        super(config);
    }

    public SarlaccConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, SarlaccConfigDefaults.INSTANCE);
    }

    public SarlaccConfigBuilder(final IniConfig config, final SarlaccConfig defaults) throws ConfigException {
        super(config, defaults);
    }

    @Override
    public SarlaccConfigBuilder self() {
        return this;
    }

    public ImmutableSarlaccConfig build() throws ConfigException, IOException {
        return new ImmutableSarlaccConfig(this);
    }
}
