package ru.yandex.mail.so.sarlacc.config;

import java.util.List;

import ru.yandex.mail.so.sarlacc.ShinglerType;
import ru.yandex.mail.so.sarlacc.ShinglesPeriod;
import ru.yandex.stater.StaterConfig;

public interface ShinglerConfig extends StaterConfig {
    /**
     * Get type of the shingler: MASS_IN, MASS_OUT, NULL, etc.
     *
     * @return type of the shingler
     */
    ShinglerType type();

    /**
     * Get TTLs for shingles of the given shingler
     *
     * @return get shingles TTL of the given shingler
     */
    List<ShinglesPeriod> shinglesPeriod();
}
