package ru.yandex.mail.so.sarlacc.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ShinglerConfigBuilder extends AbstractShinglerConfigBuilder<ShinglerConfigBuilder> {
    public ShinglerConfigBuilder() {
        super(ShinglerConfigDefaults.DEFAULTS);
    }

    public ShinglerConfigBuilder(final ShinglerConfig config) {
        super(config);
    }

    @SuppressWarnings("unused")
    public ShinglerConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, ShinglerConfigDefaults.DEFAULTS);
    }

    public ShinglerConfigBuilder(final IniConfig config, final ShinglerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ShinglerConfigBuilder self() {
        return this;
    }

    public ImmutableShinglerConfig build() throws ConfigException {
        return new ImmutableShinglerConfig(this);
    }
}
