#!/bin/bash
set -exo pipefail

source sarlacc_config_base.sh

export REPLICA_NAME=$(jq .leader.dynamicProperties.GENCFG_GROUP metainstance.json|tr -d '"'|tr 'A-Z_' 'a-z-')
export MTN_TAG=$(hostname -s)

export INDEX_DIR="$DATA_DIR/index"

case "$NANNY_SERVICE_ID" in
    sarlacc_backend)
        export CTYPE=prod
    ;;
    sarlacc_backend_testing)
        export CTYPE=testing
    ;;
esac

export SEARCHMAP_PATH="$BSCONFIG_IDIR/searchmap-${CTYPE}.txt"
