#!/bin/bash
set -exo pipefail

source sarlacc_config_base.sh

export REPLICA_NAME=$(jq .leader.dynamicProperties.GENCFG_GROUP metainstance.json|tr -d '"'|tr 'A-Z_' 'a-z-')
export MTN_TAG=$(hostname -s)

export SARLACC_LOGROTATE_DAYS=1
export PRODUCER_LOGROTATE_DAYS=1

export SARLACC_TMPDIR=/dev/shm/tmp

case "$NANNY_SERVICE_ID" in
    sarlacc)
        export CTYPE=prod
        export SARLACC_CPU_CORES=4
        export SARLACC_MEM_LIMIT=4G
    ;;
    sarlacc-testing)
        export CTYPE=testing
        export SARLACC_CPU_CORES=2
        export SARLACC_MEM_LIMIT=2G
    ;;
esac

export SARLACC_CONFIG_PATH=sarlacc-${CTYPE}.conf
export SEARCHMAP_PATH=searchmap-${CTYPE}.txt

if [ "$CTYPE" == "prod" ]; then
    export QUEUE_NAME=sologger
    export QUEUE_NAME=sarlacc
    export SHARDS=434
    export SHARDS_PER_HOST=62
elif [ "$CTYPE" == "testing" ]; then
    export QUEUE_NAME=sarlacc-test
    export SHARDS=14
    export SHARDS_PER_HOST=14
fi
