#!/bin/bash
set -x

source sarlacc-config.sh

PORTO_NAME=$(portoctl get self absolute_name)
SARLACC_CONTAINER=${PORTO_NAME}/sarlacc/proxy

function log() {
    echo $(date '+%Y-%m-%d %H:%M:%S.%3N')' '$*
}

log "Starting porter in progress"

prevPid=-1
while true; do
    pid=$(cat pids/zoolooser)
    if [ -z "$pid" ]; then
        log "Waiting for zoolooser"
        sleep 1
        continue
    elif [ "$prevPid" != "$pid" ]; then
        log "Starting porting operation"
        pidSarlacc=$(cat pids/sarlacc)
        portoctl attach -t ${SARLACC_CONTAINER} $pidSarlacc || true
        log "Porting operation DONE"
        prevPid=$pid
    fi
done

