#!/bin/bash
set -exo pipefail

source sarlacc-config.sh

export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

export CPU_CORES=${SARLACC_CPU_CORES:-4}
export MEMORY_LIMIT=${SARLACC_MEM_LIMIT:-4G}
export GC_LOG_DIR="/dev/shm/sarlacc-gclogs"

source sarlacc-classpath.sh

portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

mkdir -p $GC_LOG_DIR

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DMTN_TAG=$MTN_TAG
-DREPLICA_NAME=$REPLICA_NAME
"

GC_ARGS="
-XX:ActiveProcessorCount=$CPU_CORES
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=$CORE_DIR
-XcompilationThreads1
-Xss16M
-Xmx${MEMORY_LIMIT}
-Xms256M
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=2
-XX:ShenandoahGCMode=iu
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=100000
-XX:ShenandoahGuaranteedGCInterval=100000
-XX:ShenandoahGarbageThreshold=10
-XX:SoftRefLRUPolicyMSPerMB=1000
-XX:+PrintCodeCache
-XX:ParallelGCThreads=$CPU_CORES
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:$GC_LOG_DIR/gc.log
"

export LD_LIBRARY_PATH=$BSCONFIG_IDIR:$BSCONFIG_IDIR/sarlacc
export LD_PRELOAD=/usr/lib/libtcmalloc_minimal.so.4:$BSCONFIG_IDIR/libldpreload.so

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
MULTISTARTER_CONFIGS="\
ru.yandex.mail.so.sarlacc.Sarlacc $SARLACC_CONFIG_PATH ; \
ru.yandex.dispatcher.producer.Producer producer.conf"

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -verbose:gc \
    $GC_ARGS $NET_ARGS $APP_ARGS \
    -DPORTO=1 \
    -Djava.library.path=sarlacc:. \
    -Djava.io.tmpdir=$SARLACC_TMPDIR \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
    $MULTISTARTER_CONFIGS
