#!/bin/bash
set -exo pipefail

source sarlacc_config_base.sh

export ZOO_CLIENT_PORT=$QUEUE_CLIENT_PORT
export ZOO_HTTP_PORT=$QUEUE_HTTP_PORT
export ZOO_VOTE_PORT=$QUEUE_VOTE_PORT
export ZOO_DATA_PORT=$QUEUE_DATA_PORT
export SNAP_COUNT=1000000
export CONC_GC_THREADS=8
export PARALLEL_GCS=12
export MEMORY_GAP=$((6 * 1024 * 1024 * 1024))
export CPU_CORES=$(( CPU_CORES - 4 ))
export ADDITIONAL_ARGS="
-XX:ActiveProcessorCount=$CPU_CORES
-Dzoolooser.traffic-compress.zstd=false
-Dzoolooser.disable-write-limiter=true
-Dru.yandex.lucene.default-cache-size=512000000
-Dru.yandex.lucene.quiet-stderr=true
-Dru.yandex.lucene-storage.max-segment-size=$((128 * 1024 * 1024))
-Dru.yandex.lucene-storage.group-fields=_GROUP_NONE_
-Dru.yandex.lucene-storage.zoo-hash-bloom-filter=false
-Dru.yandex.lucene-storage.queues-count=31
-Dru.yandex.lucene-storage.index-threads=3
-Dru.yandex.lucene-storage.merge-threads=4"

export CONFIG_TEMPLATE=queue.cfg.template

