package ru.yandex.mail.so2.skeleton;

import java.util.logging.Logger;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.AsyncStringConsumer;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.mail.so.factors.samples.SamplesLoader;

public class AddSamplesHandler implements HttpAsyncRequestHandler<String> {
    private final SamplesLoader loader;

    public AddSamplesHandler(final SamplesLoader loader) {
        this.loader = loader;
    }

    @Override
    public HttpAsyncRequestConsumer<String> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Payload expected");
        }
        return new AsyncStringConsumer();
    }

    @Override
    public void handle(
        final String request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
    {
        Logger logger = (Logger) context.getAttribute(HttpServer.LOGGER);
        loader.loadFromString(request, logger);
        exchange.submitResponse();
    }
}

