package ru.yandex.mail.so2.skeleton.config;

import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.mail.so.factors.config.ExtractModulesConfig;
import ru.yandex.mail.so.factors.config.ExtractModulesConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractSo2SkeletonConfigBuilder
    <T extends AbstractSo2SkeletonConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements So2SkeletonConfig
{
    private ExtractModulesConfigBuilder extractModulesConfig;

    protected AbstractSo2SkeletonConfigBuilder(final So2SkeletonConfig config) {
        super(config);
        extractModulesConfig(config.extractModulesConfig());
    }

    protected AbstractSo2SkeletonConfigBuilder(
        final IniConfig config,
        final So2SkeletonConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        extractModulesConfig = new ExtractModulesConfigBuilder(
            config.section("extract-modules"),
            defaults.extractModulesConfig());
    }

    @Override
    public ExtractModulesConfigBuilder extractModulesConfig() {
        return extractModulesConfig;
    }

    public T extractModulesConfig(
        final ExtractModulesConfig extractModulesConfig)
    {
        this.extractModulesConfig =
            new ExtractModulesConfigBuilder(extractModulesConfig);
        return self();
    }
}

