package ru.yandex.mail.so2.skeleton.config;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.mail.so.factors.config.ImmutableExtractModulesConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableSo2SkeletonConfig
    extends ImmutableHttpProxyConfig
    implements So2SkeletonConfig
{
    private final ImmutableExtractModulesConfig extractModulesConfig;

    public ImmutableSo2SkeletonConfig(final So2SkeletonConfig config)
        throws ConfigException
    {
        super(config);
        extractModulesConfig =
            new ImmutableExtractModulesConfig(config.extractModulesConfig());
    }

    @Override
    public ImmutableExtractModulesConfig extractModulesConfig() {
        return extractModulesConfig;
    }
}

