package ru.yandex.mail.so2.skeleton.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class So2SkeletonConfigBuilder
    extends AbstractSo2SkeletonConfigBuilder<So2SkeletonConfigBuilder>
{
    public So2SkeletonConfigBuilder() {
        super(So2SkeletonConfigDefaults.INSTANCE);
    }

    public So2SkeletonConfigBuilder(final So2SkeletonConfig config) {
        super(config);
    }

    public So2SkeletonConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, So2SkeletonConfigDefaults.INSTANCE);
    }

    public So2SkeletonConfigBuilder(
        final IniConfig config,
        final So2SkeletonConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public So2SkeletonConfigBuilder self() {
        return this;
    }

    public ImmutableSo2SkeletonConfig build() throws ConfigException {
        return new ImmutableSo2SkeletonConfig(this);
    }
}

