package ru.yandex.mail.so2.config;

import java.io.File;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.mail.so2.skeleton.config.AbstractSo2SkeletonConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractSo2ConfigBuilder
    <T extends AbstractSo2ConfigBuilder<T>>
    extends AbstractSo2SkeletonConfigBuilder<T>
    implements So2Config
{
    private File spamSamplesFile;
    private long executionTimeout;
    private HttpHostConfigBuilder spdaemonConfig;

    protected AbstractSo2ConfigBuilder(final So2Config config) {
        super(config);
        spamSamplesFile(config.spamSamplesFile());
        executionTimeout(config.executionTimeout());
        spdaemonConfig(config.spdaemonConfig());
    }

    protected AbstractSo2ConfigBuilder(
        final IniConfig config,
        final So2Config defaults)
        throws ConfigException
    {
        super(config, defaults);
        spamSamplesFile =
            SPAM_SAMPLES_FILE.extract(config, defaults.spamSamplesFile());
        executionTimeout =
            EXECUTION_TIMEOUT.extract(config, defaults.executionTimeout());
        spdaemonConfig = SPDAEMON.extract(config, defaults.spdaemonConfig());
    }

    @Override
    public File spamSamplesFile() {
        return spamSamplesFile;
    }

    public T spamSamplesFile(final File spamSamplesFile) {
        this.spamSamplesFile = spamSamplesFile;
        return self();
    }

    @Override
    public long executionTimeout() {
        return executionTimeout;
    }

    public T executionTimeout(final long executionTimeout) {
        this.executionTimeout = executionTimeout;
        return self();
    }

    @Override
    public HttpHostConfigBuilder spdaemonConfig() {
        return spdaemonConfig;
    }

    public T spdaemonConfig(final HttpHostConfig spdaemonConfig) {
        this.spdaemonConfig = new HttpHostConfigBuilder(spdaemonConfig);
        return self();
    }
}

