package ru.yandex.mail.so2.config;

import java.io.File;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.mail.so2.skeleton.config.ImmutableSo2SkeletonConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableSo2Config
    extends ImmutableSo2SkeletonConfig
    implements So2Config
{
    private final File spamSamplesFile;
    private final long executionTimeout;
    private final ImmutableHttpHostConfig spdaemonConfig;

    public ImmutableSo2Config(final So2Config config) throws ConfigException {
        super(config);
        spamSamplesFile = SPAM_SAMPLES_FILE.validate(config.spamSamplesFile());
        executionTimeout =
            EXECUTION_TIMEOUT.validate(config.executionTimeout());
        spdaemonConfig = SPDAEMON.validate(config.spdaemonConfig());
    }

    @Override
    public File spamSamplesFile() {
        return spamSamplesFile;
    }

    @Override
    public long executionTimeout() {
        return executionTimeout;
    }

    @Override
    public ImmutableHttpHostConfig spdaemonConfig() {
        return spdaemonConfig;
    }
}

