package ru.yandex.mail.so2.config;

import java.io.File;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.mail.so2.skeleton.config.So2SkeletonConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.SectionConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.FileParser;
import ru.yandex.parser.string.InputFileValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface So2Config extends So2SkeletonConfig {
    ParameterConfig<File> SPAM_SAMPLES_FILE = new ParameterConfig<>(
        "spam-samples.samples-path",
        FileParser.INSTANCE,
        InputFileValidator.INSTANCE);

    ParameterConfig<Long> EXECUTION_TIMEOUT = new ParameterConfig<>(
        "so2.execution-timeout",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        SPDAEMON = new SectionConfig<>(
            "spdaemon",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    File spamSamplesFile();

    long executionTimeout();

    HttpHostConfig spdaemonConfig();
}

