package ru.yandex.mail.so2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class So2ConfigBuilder
    extends AbstractSo2ConfigBuilder<So2ConfigBuilder>
{
    public So2ConfigBuilder() {
        super(So2ConfigDefaults.INSTANCE);
    }

    public So2ConfigBuilder(final So2Config config) {
        super(config);
    }

    public So2ConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, So2ConfigDefaults.INSTANCE);
    }

    public So2ConfigBuilder(final IniConfig config, final So2Config defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public So2ConfigBuilder self() {
        return this;
    }

    public ImmutableSo2Config build() throws ConfigException {
        return new ImmutableSo2Config(this);
    }
}

