package ru.yandex.mail.so2.config;

import java.io.File;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.logger.LoggersConfig;
import ru.yandex.logger.LoggersConfigBuilder;
import ru.yandex.logger.ProxyAccessLoggerConfigDefaults;
import ru.yandex.mail.so2.skeleton.config.So2SkeletonConfigDefaults;

public class So2ConfigDefaults
    extends So2SkeletonConfigDefaults
    implements So2Config
{
    public static final String SO_RESOLUTION = "so_resolution";

    public static final So2ConfigDefaults INSTANCE =
        new So2ConfigDefaults();

    private static final LoggersConfig LOGGERS_CONFIG =
        new LoggersConfigBuilder(So2SkeletonConfigDefaults.INSTANCE.loggers())
            .accessLoggers(
                new PatternMap<>(new So2AccessLoggerConfigDefaults()));

    private static class So2AccessLoggerConfigDefaults
        extends ProxyAccessLoggerConfigDefaults
    {
        @Override
        public String logFormat() {
            return super.logFormat() + " %{" + SO_RESOLUTION + '}';
        }
    }

    protected So2ConfigDefaults() {
    }

    @Override
    public String name() {
        return "SO2";
    }

    @Override
    public LoggersConfig loggers() {
        return LOGGERS_CONFIG;
    }

    @Override
    public File spamSamplesFile() {
        return null;
    }

    @Override
    public long executionTimeout() {
        return 0L;
    }

    @Override
    public HttpHostConfig spdaemonConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }
}

