import tikaite from "common.dsl";
import deobfuscator from "common.dsl";
import fast_text from "common.dsl";

create chain extractor main(raw_mail mail, smtp_envelope envelope) -> json_map {
    create chain extractor part_processor(tikaite_doc doc) -> tikaite_doc {
        create compose_doc extractor compose_doc(
            tikaite_doc doc,
            string deobfuscated_subject,
            string deobfuscated_pure_body,
            long word_count,
            json_object fast_text_embedding)
            -> tikaite_doc
        {
        }

        deobfuscator(doc.hdr_subject.__string__) -> deobfuscated_subject;
        deobfuscator(doc.pure_body.__string__) -> deobfuscated_pure_body;
        limit_words(deobfuscated_pure_body, 64) -> truncated_pure_body, word_count;
        fast_text(truncated_pure_body) -> embedding;
        compose_doc(
            doc,
            deobfuscated_subject,
            deobfuscated_pure_body,
            word_count,
            embedding.__json_object__)
            -> deobfuscated_doc;

        return deobfuscated_doc;
    }

    create for_each_tikaite_doc extractor parts_processor(tikaite_docs docs) -> tikaite_docs {
        extractor = part_processor
    }

    create compose_doc extractor compose_doc(
        json_map base,
        json_object docs,
        json_object text_part,
        string full_body_fnv64)
        -> json_map
    {
    }

    trace tikaite(mail) -> meta, docs;
    trace parts_processor(docs) -> processed_docs;
    text_part(processed_docs) -> processed_text_part;
    trace full_body_fnv64(mail) -> full_body_fnv64;

    create_json_map() -> empty_map;

    compose_doc(empty_map, processed_docs.__json_object__, processed_text_part.__json_object__, full_body_fnv64) -> result;

    return result if not is_any_null(mail);
}

create chain extractor process_nested_mail(raw_mail mail, smtp_envelope envelope) -> json_map {
    trace nested_mail(mail) -> nested_mail;
    main(nested_mail, envelope) -> result;

    return result;
}

create chain extractor only_fast_text(raw_mail mail, smtp_envelope envelope) -> tikaite_docs {
    create chain extractor part_processor(tikaite_doc doc) -> tikaite_doc {
        create compose_doc extractor compose_doc(
            json_map doc,
            long word_count,
            json_object fast_text_embedding)
            -> tikaite_doc
        {
        }

        deobfuscator(doc.pure_body.__string__) -> deobfuscated_pure_body;
        limit_words(deobfuscated_pure_body, 64) -> truncated_pure_body, word_count;
        fast_text(truncated_pure_body) -> embedding;
        create_json_map() -> empty_doc;
        compose_doc(
            empty_doc,
            word_count,
            embedding.__json_object__)
            -> embedding_doc;

        return embedding_doc;
    }

    create for_each_tikaite_doc extractor parts_processor(tikaite_docs docs) -> tikaite_docs {
        extractor = part_processor
    }

    trace tikaite(mail) -> meta, docs;
    trace parts_processor(docs) -> processed_docs;

    return processed_docs;
}

