#!/bin/bash
set -x
RETVAL=0
READER_PATH="./Reader"
ENV_NAME_PATH="./environment.name"
RESTART_DAEMON_WAIT_TIMEOUT=25
echo "Input parameters: $@"
[ -e "$ENV_NAME_PATH" ] && ENV_NAME=$(cat $ENV_NAME_PATH)
[ -n "$ENV_NAME" ] && ENV_ROUTE=${ENV_NAME#so}

CONFIG=sp-daemon-config.sh
if test -f "$CONFIG"; then
    source "$CONFIG"
fi

CONFIG=config.sh
if test -f "$CONFIG"; then
    source "$CONFIG"
fi

set +o pipefail

wait4rediness() {
  local port=${1:-HTTP_PORT} tout=${2:-60} t=1 ret code
  while true; do
    [ "$tout" -gt "0" -a "$t" -gt "$tout" ] && break
    code=$(curl -sm $tout -o /dev/null -w '%{http_code}' "http://localhost:${port}/ping")
    [ "$?" -eq "0" ] && break
    sleep 1
    [ "$tout" -gt "0" ] && (( t += 1 ))
  done
  code=$(curl -sm $tout -o /dev/null -w '%{http_code}' "http://localhost:${port}/ping")
  ret=$?
  [ "$code" -eq "200" ] && return 0
  return $ret
}

wait_daemon() {
  local port=${1:-HTTP_PORT} RC DC PID
  wait4rediness $port $RESTART_DAEMON_WAIT_TIMEOUT; RC=$?
  DC=$(ps -ef | grep sp-daemon | grep loadbase | grep -v grep | wc -l)
  if [ "$RC" -gt "0" -a "$DC" -gt "0" ]; then
    PID=$(ps -ef | grep sp-daemon | grep loadbase | grep -v grep | awk '{print $2}')
    curl -m$RESTART_DAEMON_WAIT_TIMEOUT "http://localhost:${port}/stop"
    /bin/kill $PID; sleep 1
    wait4rediness $port $RESTART_DAEMON_WAIT_TIMEOUT; RC=$?
  fi
  return $RC
}

restart_daemon() {
  # random sleep, so instances won't be killed simultaneously
  sleep $[ ( $RANDOM % 60 ) + 1 ]
  local port=${1:-HTTP_PORT} RC PID
  PID=$(ps -ef | grep sp-daemon | grep loadbase | grep -v grep | awk '{print $2}')
  if [ -n "$PID" ]; then
    curl -m$RESTART_DAEMON_WAIT_TIMEOUT "http://localhost:${port}/stop"
    /bin/kill $PID
    sleep $RESTART_DAEMON_WAIT_TIMEOUT
  fi
  wait_daemon $port; RC=$?
  return $RC
}

reload_rules() {
  local port=${1:-HTTP_PORT} RC code
  code=$(curl -o /dev/null -w '%{http_code}' "http://localhost:$port/reopen_rules")
  [ -n "$code" -a "$code" -ne "0" -a "$code" -ne "200" ] && return 1
  RC=$?
  [ "$RC" -eq "0" -a "$code" -eq "200" ] && return 0
  wait_daemon $port; RC=$?
  return $RC
}

reload_models() {
  local port=${1:-HTTP_PORT} RC code
  code=$(curl -o /dev/null -w '%{http_code}' "http://localhost:$port/reopen_models")
  [ -n "$code" -a "$code" -ne "0" -a "$code" -ne "200" ] && return 1
  RC=$?
  [ "$RC" -eq "0" -a "$code" -eq "200" ] && return 0
  wait_daemon $port; RC=$?
  return $RC
}

for p in $@; do
  ROUTE=$ENV_ROUTE
  FOLDER_NAME=${p#!}
  FOLDER_NAME=${FOLDER_NAME#+}
  FOLDER_NAME=${FOLDER_NAME#-}
  [ -z "$ROUTE" -o "$ROUTE" = "compl" -o "$ROUTE" = "usrrep" ] && ROUTE=${FOLDER_NAME##*_}
  IS_TEST_RESOURCE=$(echo $FOLDER_NAME | grep test | wc -l)
  IS_RULES=$(echo $FOLDER_NAME | grep rules_ | grep -v dict | wc -l)
  IS_NEW_RULES=$(echo $FOLDER_NAME | grep $RULES_TAR_ENC | grep -v dict | wc -l)
  IS_MODELS=$(echo $FOLDER_NAME | grep models | wc -l)

  if [ "$IS_TEST_RESOURCE" -gt "0" ]; then
    ROUTE=${FOLDER_NAME##*test}
    ROUTE=${ROUTE##_}
  fi
  echo "Folder: $FOLDER_NAME. Route: $ROUTE. Port: $HTTP_PORT. TestResource: $IS_TEST_RESOURCE. IsRulesUpdated: $IS_RULES. IsModelsUpdated: $IS_MODELS. IsNewRulesUpdated: $IS_NEW_RULES."
  if [ "$IS_RULES" -eq "0" -a "$IS_MODELS" -eq "0" -a "$IS_NEW_RULES" -eq "0" ]; then
    restart_daemon $HTTP_PORT
    RETVAL=$?
    continue
  fi
  if [ "$IS_RULES" -gt "0" ]; then
    RULES_FOLDER="$PWD/$FOLDER_NAME/rules"
    if [ "$IS_TEST_RESOURCE" -gt "0" ]; then
        RULES_FOLDER_PROD="./rules_test_${ROUTE}_prod"
    else
        RULES_FOLDER_PROD="./rules_${ROUTE}_prod"
    fi
    [ -e "$RULES_FOLDER/common" ] && cp -f $RULES_FOLDER/common/* $RULES_FOLDER/
    [ "$ROUTE" = "corp" ] && cp -f $RULES_FOLDER/local/*.{roll,rul,dlv} $RULES_FOLDER/
    RULES_ERRORS=`$READER_PATH -R $RULES_FOLDER -C $FOLDER_NAME/.cache | grep "All fault rules:" | sed -e 's/^.*All fault rules: //' | head -n1`
    echo "Errors: $RULES_ERRORS."
    if [ "$RULES_ERRORS" -eq "0" ]; then
        mkdir -p $RULES_FOLDER_PROD
        rm -rf $RULES_FOLDER_PROD/*
        cp -rf $RULES_FOLDER/* $RULES_FOLDER_PROD/
        reload_rules $HTTP_PORT
        RETVAL=$?
    else
        echo "Checking out of rules set '$FOLDER_NAME' failed. Fault rules count: $RULES_ERRORS."
        RETVAL=1
        break
    fi
  elif [ "$IS_NEW_RULES" -gt "0" ]; then
    ./decode-unpack-rules.sh $RULES_TAR_ENC $RULES_TAR $RULES_DECODED_DIR

    RULES_FOLDER="$PWD/$RULES_DECODED_DIR"
    RULES_FOLDER_PROD="$PWD/$RULES_CHECKED_DIR"

    RULES_ERRORS=`$READER_PATH -R $RULES_FOLDER -C $FOLDER_NAME/.cache | grep "All fault rules:" | sed -e 's/^.*All fault rules: //' | head -n1`
    echo "Errors: $RULES_ERRORS."
    if [ "$RULES_ERRORS" -eq "0" ]; then
        mkdir -p $RULES_FOLDER_PROD
        rm -rf $RULES_FOLDER_PROD/*
        cp -rf $RULES_FOLDER/* $RULES_FOLDER_PROD/
        reload_rules $HTTP_PORT
        RETVAL=$?
    else
        echo "Checking out of rules set '$FOLDER_NAME' failed. Fault rules count: $RULES_ERRORS."
        RETVAL=1
        break
    fi
  elif [ "$IS_MODELS" -gt "0" ]; then
    reload_models $HTTP_PORT
    RETVAL=$?
  fi
done
exit $RETVAL
