#!/bin/bash
set -exo pipefail

source sp-daemon-config.sh

TRUSTED_ZONE_PATH=${PROG_DATA_DIR}/trusted_zone
TMP_ZONE_PATH=${TRUSTED_ZONE_PATH}.tmp

code=$(curl -s --retry 1 --retry-delay 1 -m 30 -w '%{http_code}' -o $TMP_ZONE_PATH https://ro.racktables.yandex-team.ru/export/expand-trypo-macros.php?macro=_YANDEXNETS_)
if ! test "$code" = "200"; then
    >&2 echo "Failed to retrive _YANDEXNETS_ macro:"
    cat $TMP_ZONE_PATH 1>&2
    exit 1
fi

#OUTBACKS_PATH=outbacks.tmp
#code=$(curl -s --retry 1 --retry-delay 1 -m 30 -w '%{http_code}' -o $OUTBACKS_PATH https://ro.racktables.yandex-team.ru/export/expand-trypo-macros.php?macro=_C_MAIL_POSTOUTBACK_)
#if ! test "$code" = "200"; then
#    >&2 echo "Failed to retrive _C_MAIL_POSTOUTBACK_ macro:"
#    cat $OUTBACKS_PATH 1>&2
#    exit 1
#fi
#for h in $(cat $OUTBACKS_PATH); do
#    /usr/bin/host $h | /usr/bin/awk '{if (index($NF, ":") > 0) {print $NF "/64"} else {print $NF "/32"}}' >> $TMP_ZONE_PATH
#done
#/bin/rm -f $OUTBACKS_PATH

/bin/mv -f $TMP_ZONE_PATH $TRUSTED_ZONE_PATH
