#!/bin/bash
set -x

source sp-daemon-config.sh

DT=`date -d yesterday +%Y-%m-%d`
LOGS=(
"delivery_so_${ROUTE} 0 log"
"fake-cron 3 log"
"maillog 3"
"push-client 3 log"
"shortdlv_${ROUTE} 3 log"
"access 3 log"
"error 3 log"
"ml 0 log"
"slow 2 log"
#"filter_so_${ROUTE} 1 log"
#"shingler 1 log"
)

if [ "$CTYPE" == "prod" ]; then
    LOGS+=("maillog-parser-errors 3 log" "plotnik_collector 2 log" "spam-samples-update 2 log")
    if [ "$ROUTE" == "in" ]; then
        LOGS+=("kaspersky 3 log")
    fi
fi

for log in "${LOGS[@]}"; do
	set -- $log
	file_ext=
    [ -n "$3" ] && file_ext=".$3"
	[ -f "${LOG_DIR}/$1$file_ext" ] && mv -f "${LOG_DIR}/$1$file_ext" "${LOG_DIR}/${1}_$DT$file_ext"
    touch "$1$2$file_ext"
done

/usr/bin/curl -s -v "http://localhost:${HTTP_PORT}/reopen_log"
for push_client_name in ${PUSH_CLIENTS[@]}; do
    [ -z "$push_client_name" ] && continue
    /bin/kill -TERM $(cat pids/push-client-${push_client_name})
done

for log in "${LOGS[@]}"; do
	set -- $log
    find ${LOG_DIR}/ -type f -mtime +$2 -name "${1}_*" -delete
done
