#!/usr/bin/perl -w
# -*- Encoding: utf-8; Mode: cperl -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
# Calculates values for Spamooborona daemons spider diagram
# Attempt to write more time-efficient script
#

use 5.8.0;
use strict;
use JSON;

#my $time_start = times();

my ($MAILTAIL, $MONTAIL, $WEB_FOLDER, $TIME_INTERVAL) = ($ARGV[0] || 'WORKING_DIR/tmp/mailtail.tmp', $ARGV[1] || 'WORKING_DIR/tmp/montail.tmp', $ARGV[2] || './', $ARGV[3] || 30);

(-e $MAILTAIL) or die "$MAILTAIL disappeared\n";
(-e $MONTAIL) or die "$MONTAIL disappeared\n";

my (%data, %err, %hostNames, @sf, %re, %cfg, @pars, $p, $iniFileName); %data = ();
my ($s, $m, $h, $d, $mon) = localtime;
@{$data{'info'}}{'Time', 'Total'} = (sprintf("%02d:%02d:%02d", $h, $m, $s), 0);
($data{'info'}{'Host'} = uc `hostname`) =~ s/\..*$//;
$data{'info'}{'Host'} =~ s/^(\w+-\w+)-.*$/$1/;
chomp $data{'info'}{'Host'};
($data{'labels'}, $data{'data'}) = ([], []);
($SO::LogFile::defaultLogFile, $iniFileName) = ('/logs/mondiag-polar.log', 'WORKING_DIR/so-mondiag-polar.ini');

($s, $m, $h, $d, $mon) = localtime(time() - $TIME_INTERVAL);
my $st0 = sprintf("%02d%02d%02d:%02d:%02d", $mon, $d, $h, $m, $s);
#my $st0 = '111817:19:10';
my %monthes = (Jan => 0, Feb => 1, Mar => 2, Apr => 3, May => 4, Jun => 5, Jul => 6, Aug => 7, Sep => 8, Oct => 9, Nov => 10, Dec => 11);

# Обработка файла $MAILTAIL (mailtail.tmp)
%cfg = (); @pars = ();
for $p (loadIniSection($iniFileName, 'maillog')) {
    push @{$data{'labels'}}, shift @{$$p{'value'}}; push @pars, $$p{'param'};
    $hostNames{pop @{$$p{'value'}}} = $$p{'param'} if scalar @{$$p{'value'}} > 2;
    $cfg{$$p{'param'}}{'err'} = [map {qr/$_/} split("','", $$p{'value'}[0])];
    $cfg{$$p{'param'}}{'total'} = [map {qr/$_/} split("','", $$p{'value'}[1])] if scalar @{$$p{'value'}} > 1
}
$re{$_} = qr/\b$_ .*? (disabled|enabled) for (\d+)/ foreach (keys %hostNames);
open(FH, '<', $MAILTAIL) or die "Error while opening file '$MAILTAIL': $!\n";
while (my $line = <FH>) {
    next if $line =~ /^\W/;
    @sf = split ' ', $line, 6;
    next if !defined($sf[0]) or !exists($monthes{$sf[0]}) or sprintf("%02d%02d", $monthes{$sf[0]}, $sf[1]).$sf[2] lt $st0;
    ++$data{'info'}{'Total'} if $sf[5] =~ /^starts with /;
    for $p (keys %cfg) {
        ++$err{$p} if $sf[5] ~~ @{$cfg{$p}{'err'}};
        ++$err{"${p}_TOTAL"} if $cfg{$p}{'total'} and scalar(@{$cfg{$p}{'total'}}) and $sf[5] ~~ @{$cfg{$p}{'total'}}
    }
    foreach (keys %re) {
        next unless $sf[5] =~ $re{$_};
        $data{'hosts'}{$hostNames{$_}} = $1 eq 'disabled' ? $2 : 0;
    }
}
close(FH);
push @{$data{'data'}}, calc_perc($err{$_}, $err{"${_}_TOTAL"}) foreach (@pars);

# Обработка файла $MONTAIL (montail.tmp)
%cfg = (); @pars = ();
for $p (loadIniSection($iniFileName, 'monlog')) {
    push @{$data{'labels'}}, shift @{$$p{'value'}}; push @pars, $$p{'param'};
    $hostNames{pop @{$$p{'value'}}} = $$p{'param'} if scalar @{$$p{'value'}} > 1;
    $cfg{$$p{'param'}} = [qr/<$$p{value}[0]@{[ substr(${$$p{value}}[0], -1) eq ':' ? '..' : '' ]},[0-9]+,[^O]/, qr/<${$$p{value}}[0]\S+/]
}
open (FH, '<', $MONTAIL) or die "Error while opening file '$MONTAIL': $!\n";
while (my $line = <FH>) {
    @sf = split ' ', $line, 9;
    next if !defined($sf[0]) or !exists($monthes{$sf[0]}) or sprintf("%02d%02d", $monthes{$sf[0]}, $sf[1]).$sf[2] lt $st0;
    for $p (keys %cfg) {
        ++$err{$p} if $sf[8] =~ $cfg{$p}[0];
        ++$err{"${p}_TOTAL"} if $sf[8] =~ $cfg{$p}[1]
    }
}
close(FH);
push @{$data{'data'}}, calc_perc($err{$_}, $err{"${_}_TOTAL"} || 0) + 0 foreach (@pars);

open (FH, '>', $WEB_FOLDER . 'monitoring_data.json') or die "Error while opening file 'monitoring_data.json': $!\n";
print FH to_json(\%data);
close FH;

#printf "The process took %.6f sec.\n", times() - $time_start;

sub calc_perc {
    my ($err_count, $total) = @_; $err_count ||= 0;
    $total = $data{'info'}{'Total'} unless defined $total; $total ||= 0;
    $total >= 0 && $err_count <= $total ? ($err_count > 0 && $total > 0 ? min(int(100 - ($err_count * 100 / $total)), 95) : 100) : 0;
}

sub min {                       # Вычисляем минимум из произвольного набора чисел
    my $x = shift;
    foreach (@_) { $x = $_ if $x > $_ }
    $x
}

sub loadIniSection {
    my ($logFileName, $section) = @_;
    my ($qr, $s, @items) = (qr/^\s*\[\s*$section\s*\]\s*$/, 0);
    open(FH_INI, '<', $logFileName) or warn("Unable to open file '$logFileName' for reading: $!\n"), return;
    local $/ = "\n";
    while (my $line = <FH_INI>) {
        next if $line =~ /^#/;
        $s = 0 if $line =~ /^\s*$/;
        $s = $line =~ /$qr/ unless $s;
        next unless $s;
        push @items, {'param' => $1, 'value' => [map {s/^\'//;s/\'\s*$//;chomp;$_} split(/\$/, $2)]} if $line =~ /^([\w\.-]+)\s*=\s*([^#]+)\s*(?:\#.*)?$/
    }
    close(FH_INI); @items
}
