#!/bin/bash
set -exo pipefail

source config.sh

export STATE_DIR=/state
export HOME_DIR=${BSCONFIG_IDIR:-.}
export PROG_DATA_DIR=${HOME_DIR}/var/yamail
export INI_FILE=${HOME_DIR}/spam.ini
export RULES_DECODED_DIR=rules
export RULES_TAR="$RULES_DECODED_DIR.tar.gz"
export RULES_TAR_ENC="$RULES_TAR.enc"
export RULES_CHECKED_DIR=rules_checked
export ALL_CAS_PATH=./allCAs.pem
export DOMEN_FACTORS_TRIE=./DomenFactorsTrie

export RECORDER_DICT_PATH=$PROG_DATA_DIR/dict.dict
export TRUSTED_ZONES_PATH=$PROG_DATA_DIR/trusted_zone
export INTRANET_ZONES_PATH=$PROG_DATA_DIR/intranet_zone
export LOCAL_ZONES_PATH=$PROG_DATA_DIR/local_zone

export TEXT_TO_VEC_DSSM=./mail-model.dssm

case "$NANNY_SERVICE_ID" in
    spdaemon-prod-in-myt|spdaemon-prod-in-iva|spdaemon-prod-in-vla|spdaemon-prod-in-sas|spdaemon-canary-in)
        export BALANCER=so-in.yandex.ru
        export TEST_BALANCER=testing-in.so.yandex-team.ru
        export SOLVER_THREADS_COUNT=32
        export PUSH_CLIENTS=(spdaemon yt)
        export PUSH_CLIENT_TVM_ID=2016955
        export LOG_LEVEL=INFO
        export EXTRA_CONFIG=spdaemon-configs/stub.conf
        ;;
    spdaemon-prod-out-sas|spdaemon-prod-out-vla|spdaemon-prod-out-myt|spdaemon-prod-out-iva|spdaemon-canary-out)
        export BALANCER=so-out.yandex.ru
        export TEST_BALANCER=testing-out.so.yandex-team.ru
        export SOLVER_THREADS_COUNT=32
        export PUSH_CLIENTS=(spdaemon yt)
        export PUSH_CLIENT_TVM_ID=2016957
        export LOG_LEVEL=INFO
        export EXTRA_CONFIG=spdaemon-configs/stub.conf
        ;;
    spdaemon-prod-corp-sas|spdaemon-prod-corp-vla|spdaemon-prod-corp-myt|spdaemon-prod-corp-iva|spdaemon-canary-corp)
        export BALANCER=socorp.mail.yandex.net
        export TEST_BALANCER=testing-corp.so.yandex-team.ru
        export SOLVER_THREADS_COUNT=8
        export PUSH_CLIENTS=(spdaemon yt)
        export PUSH_CLIENT_TVM_ID=2016959
        export LOG_LEVEL=INFO
        export EXTRA_CONFIG=spdaemon-configs/stub.conf
        ;;
    spdaemon-testing-mail-in)
        export BALANCER=so-testing.so.yandex-team.ru
        export PUSH_CLIENTS=()
        export LOG_LEVEL=INFO
        export EXTRA_CONFIG=spdaemon-configs/stub.conf
        ;;
    spdaemon-testing-mail-out)
        export BALANCER=so-testing-out.so.yandex-team.ru
        export PUSH_CLIENTS=()
        export LOG_LEVEL=INFO
        export EXTRA_CONFIG=spdaemon-configs/stub.conf
        ;;
    spdaemon-testing-mail-corp)
        export BALANCER=so-testing-corp.so.yandex-team.ru
        export PUSH_CLIENTS=()
        export LOG_LEVEL=INFO
        export EXTRA_CONFIG=spdaemon-configs/stub.conf
        ;;
    spdaemon-testing-in)
        export BALANCER=testing-in.so.yandex-team.ru
        export PUSH_CLIENTS=(sologger)
        export LOG_LEVEL=DEBUG
        export EXTRA_CONFIG=spdaemon-configs/spdaemon-testing-in.conf
        ;;
    spdaemon-testing-out)
        export BALANCER=testing-out.so.yandex-team.ru
        export PUSH_CLIENTS=(sologger)
        export LOG_LEVEL=DEBUG
        export EXTRA_CONFIG=spdaemon-configs/spdaemon-testing-out.conf
        ;;
    spdaemon-testing-corp)
        export BALANCER=testing-corp.so.yandex-team.ru
        export PUSH_CLIENTS=(sologger)
        export LOG_LEVEL=DEBUG
        export EXTRA_CONFIG=spdaemon-configs/spdaemon-testing-corp.conf
        ;;
esac

export MAILLOG_PATH="${LOG_DIR}/maillog"
export DELIVERYLOG_PATH="${LOG_DIR}/delivery_so_${ROUTE}.log"
export SHORTLOG_PATH="${LOG_DIR}/shortdlv_${ROUTE}.log"
export MLLOG_PATH="${LOG_DIR}/ml.log"
export FILTERLOG_PATH="${LOG_DIR}/filter_so_${ROUTE}.log"
export KASPERSKYLOG_PATH"=${LOG_DIR}/kaspersky.log"
export ACCESSLOG_PATH"=${LOG_DIR}/access.log"
export ERRORLOG_PATH="${LOG_DIR}/error.log"
export SLOWLOG_PATH="${LOG_DIR}/slow.log"
export RULES_DICT_PATH="${HOME_DIR}/rules_dict_${ROUTE}.txt"

if [ "$CTYPE" == "prod" ]; then
    export RULES_DIR="${HOME_DIR}/rules_${ROUTE}/rules"
    export RULES_DIR_PROD="${HOME_DIR}/rules_${ROUTE}_prod"
    export THREADS_COUNT=16
elif [ "$CTYPE" == "testing" ]; then
    export RULES_DIR="${HOME_DIR}/rules_test_${ROUTE}/rules"
    export RULES_DIR_PROD="${HOME_DIR}/rules_test_${ROUTE}_prod"
    export TVM_CLIENT_ID=2010396
    export SOLVER_THREADS_COUNT=32
    export THREADS_COUNT=16
fi

if [ "$ROUTE" == "in" ]; then
    export YT_LOG_TYPE=mail-so-ml-log
elif [ "$ROUTE" == "out" ]; then
    export YT_LOG_TYPE=mail-so-out-log
elif [ "$ROUTE" == "corp" ]; then
    export YT_LOG_TYPE=mail-so-corp-log
fi
