#!/bin/bash
set -ex

# prepare environment
source sp-daemon-config.sh
source config_utils.sh

if [ "$CTYPE" == "prod" ]; then
    echo "so$ROUTE" > environment.name
elif [ "$CTYPE" == "testing" ]; then
    echo "sotest$ROUTE" > environment.name
fi
mkdir -p pids
mkdir -p ${STATE_DIR}/so-log-tail
mkdir -p /usr/local/www
mkdir -p plotnik_checks
mkdir -p .pgsql
mkdir -p ${LOG_DIR}/push-client
mkdir -p ${RULES_DIR_PROD}
[ ! -e "/usr/local/www/logs" ] && ln -s $LOG_DIR /usr/local/www/logs
[ ! -e "/webcache" ] && ln -s $STATE_DIR /webcache

# unarchiving
tar xvf ./sp-daemon-data.tar.gz
if [ "$ROUTE" == "in" -a "$CTYPE" == "testing" ]; then
    [ -e "./text2vec_dssm.tar.gz" ] && tar xvf ./text2vec_dssm.tar.gz
fi

if test -e ./ocraas-jniwrapper.tar.gz
then
    tar xf ocraas-jniwrapper.tar.gz
fi

if test -e $RULES_TAR_ENC
then
    ./decode-unpack-rules.sh $RULES_TAR_ENC $RULES_TAR $RULES_DECODED_DIR
    mkdir -p $RULES_CHECKED_DIR
    cp -rf $RULES_DECODED_DIR/* $RULES_CHECKED_DIR/
fi

# prepare tikaite
tar xf yandex-ibm-jdk.tar.xz
./prepare-script.sh

config_files=(spam-${ROUTE}-${CTYPE}.ini logrotate.conf)

# prepare initial state of files & dirs
touch $DELIVERYLOG_PATH
touch ${STATE_DIR}/logrotate
for push_client_name in ${PUSH_CLIENTS[@]}; do
    [ -z "$push_client_name" ] && continue
    touch ${LOG_DIR}/push-client/${push_client_name}.log
    mkdir -p ${STATE_DIR}/push-client-${push_client_name}
    config_files+=(push-client-${push_client_name}.yaml)
done
if [ "$ROUTE" == "in" -a "$CTYPE" == "prod" ]; then
    echo '  - name: $(KASPERSKYLOG_PATH)' >> ${HOME_DIR}/templates/push-client-spdaemon.yaml.template
    echo '    send_delay: 30' >> ${HOME_DIR}/templates/push-client-spdaemon.yaml.template
fi

# prepare files: attributes & substitutes
chmod +x *.sh *.py
sed -i "s#WORKING_DIR#${HOME_DIR}#g" *.py *.sh
for file_path in ${config_files[@]}; do
    cp "${HOME_DIR}/templates/${file_path}.template" "${HOME_DIR}/$file_path"
    # walk through all referenced vars and substitute by its values
    substitute_vars $file_path
    # substitutes all includes
    substitute_includes $file_path
    # walk through all referenced vars and substitute by its values
    substitute_vars $file_path
    # do calculations of expressions & replace latter by result of first
    calc_expressions $file_path
done
[ ! -e "./spam.ini" ] && ln -s spam-${ROUTE}-${CTYPE}.ini spam.ini

# preparing of rules
if [ "$CTYPE" == "testing" ]; then
    if [ "$ROUTE" == "corp" ]; then
        cp test_so_in_version.rul ${RULES_DIR}/
    else
        cp test_so_${ROUTE}_version.rul ${RULES_DIR}/
    fi
fi
if [ "$ROUTE" == "corp" ]; then
    cp ${RULES_DIR}/local/*.{roll,rul,dlv} ${RULES_DIR}/
fi
cp -r ${RULES_DIR}/* ${RULES_DIR_PROD}/
[ -e "${RULES_DIR}/common" ] && cp -f ${RULES_DIR}/common/* ${RULES_DIR_PROD}/
if [ "$CTYPE" == "testing" ]; then
    mkdir -p ${LOG_DIR}/testing
    [ ! -e "${LOG_DIR}/testing/so_${ROUTE}.log" ] && ln -s $DELIVERYLOG_PATH ${LOG_DIR}/testing/so_${ROUTE}.log
fi

# prepare trusted zones
./generate-trusted-zones.sh

# prepare secrets
[ ! -e "./allCAs.pem" ] && ln -s so-allcas/cert allCAs.pem

if [ "$CTYPE" == "prod" ]; then
    # prepare plotnik
    [ ! -e "./.pgsql/root.crt" ] && ln -s ../so-allcas/cert .pgsql/root.crt
    [ ! -e "./.pgpass.plotnik" ] && ln -s so-plotnik-db/pass .pgpass.plotnik
    [ ! -e "plotnik_checks/so-maillog-parser.sh" ] && cp so-maillog-parser.sh plotnik_checks/so-maillog-parser.sh
fi
