#!/bin/bash

set -e
set -u
set -f
set -x
#set -o pipefail
#shopt -s failglob

date
echo 'Spamstop updater launched'
RULES_DIR='WORKING_DIR/var/yamail/rules'
STATUS_FILE='WORKING_DIR/state/rules_update_status'

# Sleep for async
sleep $((RANDOM%600))

cd $RULES_DIR

# get current commit
old_ver="$(git rev-parse HEAD)"

current_branch="$(git rev-parse --abbrev-ref HEAD)"
# get latest origin/stable
# probably there is a better way
echo 'Attempting to get latest rules'

set +e
GIT_TRACE=1 GIT_SSH='WORKING_DIR/ssh-rules.sh' git fetch origin \
&& git reset --hard "origin/$current_branch" # && git clean -f -d

return_code=$?
set -e

if (( $return_code != 0 )); then
    echo -e "status: error\ntime: `date +%s`\nsbj: git pull failed" >$STATUS_FILE
        exit 1
fi

new_ver=$(git rev-parse HEAD)

echo "Currently at      $old_ver"
echo "Previously was at $new_ver"

env_name="$(cat WORKING_DIR/environment.name)"

# Corp requires some extra rules
if [[ "$env_name" == "socorp" ]]; then
    echo "Copying some stuff for corp"
    # enable wildcard expansion for a moment
    set +f
    cp $RULES_DIR/local/cmail* $RULES_DIR/
    set -f
fi

need_restart='not_sure'
# see if we need to restart the service
if [[ "$env_name" == "soout" ]]; then
    # trigger a restart if subfolder has been changed
    git diff --name-status "$old_ver" "$new_ver" \
        | fgrep 'outgoing/' \
        && need_restart=1
else
    # soin and socorp
    git diff --name-status "$old_ver" "$new_ver" \
        | fgrep -v '/' \
        && need_restart=1
fi

# git diff could fail if old HEAD is not already in the repo
if [[ "$need_restart" == "not_sure" ]]; then
    git diff --name-status "$old_ver" "$new_ver"
    if (( $? != 0 )); then
        echo 'git diff failed for some reason. old HEAD deleted?'
        need_restart=1
    else
        need_restart=0
    fi
fi

if (( $need_restart == 1 )); then
    echo 'Restarting sp-daemon'
    # should replace with kill -USR1 after fixing
    # https://st.yandex-team.ru/SODEV-861#1478097690000
    kill `cat WORKING_DIR/pids/sp-daemon`
    echo -e "status: success\ntime: `date +%s`\nsbj: rules up-to-date; sp-daemon restarted" >$STATUS_FILE
else
    echo 'No need to restart'
    echo -e "status: success\ntime: `date +%s`\nsbj: rules up-to-date; no restart needed" >$STATUS_FILE
fi
