#include <library/cpp/getopt/last_getopt.h>
#include <mail/so/daemons/sp-daemon/lib/sp-daemon-server.h>

int main(int argc, char* argv[]) {
    Y_VERIFY(setlocale(LC_CTYPE, "ru_RU.koi8r"));

    TFsPath ini;
    {
        NLastGetopt::TOpts opts;
        opts.AddCharOption('i', "path to spam.ini file").StoreResult(&ini).Required();
        NLastGetopt::TOptsParseResult parsedOpts(&opts, argc, argv);
    }

    Y_VERIFY(ini.IsFile());

    const TSoConfig config = [&ini] {
        TIFStream stream(ini);
        return TSoConfig(NConfig::TConfig::FromIni(stream));
    }();

    TSpDaemonServer spDaemonServer(config);

    spDaemonServer.Start();

    spDaemonServer.Wait();

    return 0;
}
