package ru.yandex.mail.so.logger;

import java.util.logging.Level;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.CgiParams;

public abstract class AbstractDeliveryLogRecordContext implements LogRecordContext {
    protected final SpLogger spLogger;
    protected final CgiParams params;
    protected final String service;
    protected final LogStorageType storageType;
    protected String logRecord;
    protected Route route;
    protected long ttl;

    protected AbstractDeliveryLogRecordContext(final LogContext context) {
        this(context.spLogger(), context.params(), context.storageType(), context.route());
    }

    protected AbstractDeliveryLogRecordContext(
        final SpLogger spLogger,
        final CgiParams params,
        final LogStorageType storageType,
        final Route route)
    {
        this.spLogger = spLogger;
        this.params = params;
        this.storageType = storageType;
        service = service();
        logRecord = null;
        this.route = route;
        ttl = DEFAULT_TTL;
    }
    protected AbstractDeliveryLogRecordContext(
        final SpLogger spLogger,
        final CgiParams params,
        final LogStorageType storageType,
        final String logRecord,
        final Route route)
    {
        this(spLogger, params, storageType, route);
        this.logRecord = logRecord;
        try {
            init(params);
        } catch (BadRequestException | NumberFormatException e) {
            spLogger.logger().log(Level.SEVERE, "Session params getting failed", e);
        }
    }

    @Override
    public SpLogger spLogger() {
        return spLogger;
    }

    @Override
    public String name() {
        return "delivery";
    }

    @Override
    public CgiParams params() {
        return params;
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public LogStorageType storageType() {
        return storageType;
    }

    @Override
    public String logRecord() {
        return logRecord;
    }

    @Override
    public void setLogRecord(final String logRecord) {
        this.logRecord = logRecord;
    }

    @Override
    public long ttl() {
        return ttl;
    }

    @Override
    public void setTTL(final long ttl) {
        this.ttl = ttl;
    }

    @Override
    public Route route() {
        return route;
    }

    public void setRoute(final Route route) {
        this.route = route;
    }
}
