package ru.yandex.mail.so.logger;

import ru.yandex.mail.so.logger.config.LogStorageConfig;

public abstract class AbstractLogStorage<P extends RoutedLogRecordProducer> implements LogStorage<P> {

    protected final String storageName;
    protected final LogStorageConfig config;

    protected AbstractLogStorage(final String storageName, final LogStorageConfig config) {
        this.storageName = storageName;
        this.config = config;
    }

    @Override
    public String name() {
        return storageName;
    }

    @Override
    public LogStorageConfig config() {
        return config;
    }
}
