package ru.yandex.mail.so.logger;

import ru.yandex.mail.so.logger.config.RulesStatDatabaseConfig;

public abstract class AbstractRulesStatDatabase<P extends RoutedLogRecordProducer> implements RulesStatDatabase<P> {
    protected final String configName;
    protected final RulesStatDatabaseConfig<P> config;

    protected AbstractRulesStatDatabase(final String configName, final RulesStatDatabaseConfig<P> config) {
        this.configName = configName;
        this.config = config;
    }

    @Override
    public String name() {
        return configName;
    }

    @Override
    public RulesStatDatabaseConfig<P> config() {
        return config;
    }
}
