package ru.yandex.mail.so.logger;

import ru.yandex.mail.so.logger.config.AuxiliaryStorageConfig;
import ru.yandex.mail.so.logger.config.AuxiliaryStorageConfigBuilder;
import ru.yandex.mail.so.logger.config.ConfigFactory;
import ru.yandex.mail.so.logger.config.ImmutableAuxiliaryStorageConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum AuxiliaryStorageType implements ConfigFactory<AuxiliaryStorageConfig> {
    NULL {
        @Override
        public AuxiliaryStorage createStorage(
            final SpLogger spLogger,
            final ImmutableAuxiliaryStorageConfig config,
            final String name)
            throws LogStorageException
        {
            return new NullAuxiliaryStorage(spLogger, config, name);
        }
    },
    LOGS_CONSUMER {
        @Override
        public AuxiliaryStorage createStorage(
            final SpLogger spLogger,
            final ImmutableAuxiliaryStorageConfig config,
            final String name)
            throws LogStorageException
        {
            return new LogsConsumerAuxiliaryStorage(spLogger, config, name);
        }
    },
    STATLOG {
        @Override
        public AuxiliaryStorage createStorage(
            final SpLogger spLogger,
            final ImmutableAuxiliaryStorageConfig config,
            final String name)
            throws LogStorageException
        {
            return null;
        }
    };

    public abstract AuxiliaryStorage createStorage(
        final SpLogger spLogger,
        final ImmutableAuxiliaryStorageConfig config,
        final String name)
        throws LogStorageException;

    @Override
    public AuxiliaryStorageConfig createConfig(IniConfig config, String name, AuxiliaryStorageConfig defaults)
        throws ConfigException
    {
        return new AuxiliaryStorageConfigBuilder(config, name, defaults);
    }
}
