package ru.yandex.mail.so.logger;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;

import org.apache.http.entity.ContentType;

import ru.yandex.base64.Base64;
import ru.yandex.data.compressor.CompressorException;
import ru.yandex.data.compressor.DataCompressor;

public class BasicLogRecordProducer implements LogRecordProducer {
    protected String logRecord;
    protected final ContentType expectedContentType;

    public BasicLogRecordProducer(final String logRecord, final ContentType expectedContentType) {
        this.logRecord = logRecord;
        this.expectedContentType = expectedContentType;
    }

    public BasicLogRecordProducer(
        @Nonnull final String payload,
        @Nonnull final ContentType expectedContentType,
        @Nonnull final ContentType inputContentType,
        @Nonnull final DataCompressor decompressor)
        throws CompressorException
    {
        this(payload, expectedContentType);
        if (expectedContentType.getMimeType().equals(inputContentType.getMimeType())
                && decompressor != DataCompressor.RAW)
        {
            logRecord = decompressor.unbase64AndUncompress(payload, Base64.URL);
        } else {
            System.err.println("BasicLogRecordProducer: logRecord left unchanged: expected MIME-type = "
                + expectedContentType.getMimeType() + ", actual MIME-type = " + inputContentType.getMimeType()
                + ", decompressor = " + decompressor);
        }
    }

    public BasicLogRecordProducer(
        @Nonnull final String payload,
        @Nonnull final String separator,
        @Nonnull final ContentType expectedContentType,
        @Nonnull final ContentType inputContentType,
        @Nonnull final DataCompressor decompressor)
        throws CompressorException
    {
        this(payload, expectedContentType);
        if (expectedContentType.getMimeType().equals(inputContentType.getMimeType())
                && decompressor != DataCompressor.RAW)
        {
            logRecord = decompressor.unbase64AndUncompress(payload, Base64.URL);
            if (!logRecord.endsWith(separator)) {
                logRecord += separator;
            }
        } else {
            System.err.println("BasicLogRecordProducer: logRecord left unchanged: expected MIME-type = "
                + expectedContentType.getMimeType() + ", actual MIME-type = " + inputContentType.getMimeType()
                + ", decompressor = " + decompressor);
        }
    }

    @Override
    public String logRecord() {
        return logRecord;
    }

    @SuppressWarnings({"StringSplitter", "unused"})
    public List<BasicLogRecordProducer> split() {
        List<BasicLogRecordProducer> logRecordProducers = new ArrayList<>();
        for (String log : logRecord.split("\n")) {
            logRecordProducers.add(new BasicLogRecordProducer(log, expectedContentType));
        }
        return logRecordProducers;
    }
}
