package ru.yandex.mail.so.logger;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;

import org.apache.http.entity.ContentType;

import ru.yandex.data.compressor.CompressorException;
import ru.yandex.data.compressor.DataCompressor;

public class BasicRoutedLogRecordProducer extends BasicLogRecordProducer implements RoutedLogRecordProducer
{
    protected final Route route;

    public BasicRoutedLogRecordProducer(
        final String logRecord,
        final ContentType expectedContentType,
        final Route route)
    {
        super(logRecord, expectedContentType);
        this.route = route;
    }

    public BasicRoutedLogRecordProducer(
        @Nonnull final String payload,
        @Nonnull final Route route,
        @Nonnull final ContentType expectedContentType,
        @Nonnull final ContentType inputContentType,
        @Nonnull final DataCompressor decompressor)
        throws CompressorException
    {
        super(payload, expectedContentType, inputContentType, decompressor);
        this.route = route;
    }

    @SuppressWarnings("unused")
    public BasicRoutedLogRecordProducer(
        @Nonnull final String payload,
        @Nonnull final String separator,
        @Nonnull final Route route,
        @Nonnull final ContentType expectedContentType,
        @Nonnull final ContentType inputContentType,
        @Nonnull final DataCompressor decompressor)
        throws CompressorException
    {
        super(payload, separator, expectedContentType, inputContentType, decompressor);
        this.route = route;
    }

    @Override
    public Route route() {
        return route;
    }

    @SuppressWarnings({"StringSplitter", "unused"})
    @Override
    public List<BasicLogRecordProducer> split() {
        List<BasicLogRecordProducer> logRecordProducers = new ArrayList<>();
        for (String log : logRecord.split("\n")) {
            logRecordProducers.add(new BasicRoutedLogRecordProducer(log, expectedContentType, route));
        }
        return logRecordProducers;
    }
}
