package ru.yandex.mail.so.logger;

import ru.yandex.json.parser.JsonException;

public interface Batch<P extends RoutedLogRecordProducer> {
    /**
     * Get count of records in the batch
     *
     * @return count of records in the batch
     */
    long count();

    /**
     * Whether this batch is empty
     *
     * @return flag whether this batch is empty
     */
    boolean isEmpty();

    /**
     * Get lifetime of this batch
     *
     * @return lifetime of this batch
     */
    long lifeTime();

    /**
     * Reset content of the batch
     */
    void reset();

    /**
     * Add log record to this batch
     *
     * @param logRecordProducer producer of log record that to be saved to DB
     * @throws JsonException exception while processing of log record, which expected to be in JSON format
     */
    void add(final P logRecordProducer) throws JsonException;

    /**
     * Get state of the batch
     * @return state of the batch
     */
    BatchState state();

    /**
     * Set up state of the batch
     * @param state state of the batch
     */
    void setState(final BatchState state);

    /**
     * Whether this batch is ready to be saved
     *
     * @return flag whether batch is ready to be saved
     */
    default boolean isReady() {
        return state() == BatchState.READY_TO_SAVE;
    }

    /**
     * Set flag of readiness for saving of the batch
     */
    default void ready() {
        setState(BatchState.READY_TO_SAVE);
    }

    /**
     * Set flag of unreadiness for saving of the batch
     */
    default void notReady() {
        setState(BatchState.INITED);
    }
}
