package ru.yandex.mail.so.logger;

import java.io.IOException;
import java.util.logging.Logger;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.mail.so.logger.config.BatchSaverConfig;
import ru.yandex.mail.so.logger.config.ConfigFactory;

public interface BatchHandler<P extends RoutedLogRecordProducer, C extends BatchSaverConfig>
    extends GenericAutoCloseable<IOException>
{
    /**
     * Get related batch saver thread
     *
     * @return related batch saver thread
     */
    BatchSaver<P, C> batchSaver();

    /**
     * Get config for related batch saver
     *
     * @return config for related batch saver
     */
    C config();

    /**
     * Saves the batch.
     *
     * @param batch batch to be saved
     * @param logger logger for diagnostic messages
     * @return whether the attempt to save batch really starts
     */
    boolean saveBatch(final Batch<P> batch, final Logger logger);

    /**
     * Get current batch
     *
     * @return current batch
     */
    Batch<P> currentBatch();

    /**
     * Whether current batch is empty
     *
     * @return whether current batch is empty
     */
    default boolean batchIsEmpty() {
        return currentBatch().isEmpty();
    }

    /**
     * Resets the batch.
     *
     * @return old (current before resetting) batch
     */
    Batch<P> resetBatch();

    /**
     * Get type of the batch saver
     *
     * @return type of the batch saver
     */
    default ConfigFactory<? extends BatchSaverConfig> type() {
        return config().type();
    }

    /**
     * Get symbolic name of this config.
     *
     * @return name of the config
     */
    default String name() {
        return config().name();
    }

    /**
     * Decrements batches count.
     */
    default void decrementBatchesCount() {
        batchSaver().decrementBatchesCount();
    }
}
