package ru.yandex.mail.so.logger;

import java.util.logging.Logger;

import com.mongodb.bulk.BulkWriteResult;
import org.apache.http.concurrent.FutureCallback;

public class BulkWriteSubscriber extends OperationSubscriberWithCallback<BulkWriteResult> {
    public BulkWriteSubscriber(
        final FutureCallback<Void> callback,
        final String opName,
        final Logger logger)
    {
        super(callback, opName, logger);
    }

    @Override
    public void hookOnComplete() {
        super.hookOnComplete();
        BulkWriteResult result = result().get(0);
        logger.info("Operation '" + opName + "' onComplete: matched = " + result.getMatchedCount() + ", inserted = "
            + result.getInsertedCount() + ", modified = " + result.getModifiedCount());
    }
}
