package ru.yandex.mail.so.logger;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class DeliveryLogRecordsContext extends NullLogRecordsContext {

    public DeliveryLogRecordsContext(
        final SpLogger spLogger,
        final ProxySession session,
        final LogStorageType storageType,
        final Route route)
    {
        super(spLogger, session, storageType, route);
    }

    @Override
    public void init(final JsonObject json) throws JsonException {
        if (json.type() == JsonObject.Type.LIST) {
            for (final JsonObject hit : json.asList()) {
                init(hit.asMap());
            }
        } else if (json.type() == JsonObject.Type.MAP) {
            init(json.asMap());
        }
    }

    private void init(final JsonMap jsonMap) throws JsonException {
        if (jsonMap.containsKey(HITS_COUNT) && jsonMap.getLong(HITS_COUNT) > 0) {
            JsonList list = jsonMap.getList(HITS_ARRAY);
            for (final JsonObject item : list) {
                String queueid = item.get(IndexField.QUEUEID.fieldName()).asStringOrNull();
                String stid = item.get(IndexField.STID.fieldName()).asStringOrNull();
                session.logger().info("DeliveryLogRecordsContext.init: queueid=" + queueid + ", stid=" + stid);
                records.add(new DeliveryLogRecordContext(this, item.asMap()));
            }
        }
    }

    @Override
    public LogRecordsHandlerType handlerType() {
        return LogRecordsHandlerType.SP_DAEMON;
    }
}
