package ru.yandex.mail.so.logger;

public enum IndexField {
    ID("id", 0),
    TYPE("log_type", 2),
    QUEUEID("log_queueid", 1),
    UID("log_uid", 2),
    RCPT_UID("log_rcpt_uid", 3),
    CODE("log_code", 13),
    FROMADDR("log_fromaddr", 7),
    MSGID("log_msgid", 8),
    SOURCE_IP("log_source_ip", 9),
    MX("log_mx", 12),
    LOCL("log_locl", 10),
    TS("log_ts", 11),
    STID("log_stid", 4),
    OFFSET("log_offset", 5),
    SIZE("log_size", 6),
    ROUTE("log_route", 14),
    EXPIRE_TIMESTAMP("log_expire_timestamp", 15),
    BYTES_OFFSET("log_bytes_offset", 16),
    BYTES_SIZE("log_bytes_size", 17);

    private final String fieldName;
    private final int order;

    IndexField(final String fieldName, final int order) {
        this.fieldName = fieldName;
        this.order = order;
    }

    public String fieldName() {
        return fieldName;
    }

    public int order() {
        return order;
    }

    @Override
    public String toString() {
        return fieldName;
    }
}
