package ru.yandex.mail.so.logger;

import ru.yandex.parser.uri.CgiParams;

public interface LogContext {
    String HITS_COUNT = "hitsCount";
    String HITS_ARRAY = "hitsArray";
    String PREFIX = "prefix";

    /**
     * Default TTL for the log records: 14 days
     */
    long DEFAULT_TTL = 14 * 86400;

    /**
     * Get instance of SpLogger related this context
     *
     * @return instance of SpLogger related this context
     */
    SpLogger spLogger();

    /**
     * Get CGI-parameters related to the context
     *
     * @return CGI-parameters related to the context
     */
    CgiParams params();

    /**
     * Get type of the log handler according to type of input delivery log: SP_DAEMON, NULL, etc.
     *
     * @return type of the log handler
     */
    LogRecordsHandlerType handlerType();

    /**
     * Get logs basic storage's type: MDS, NULL, etc.
     *
     * @return logs basic storage's type
     */
    LogStorageType storageType();

    /**
     * Get route associated to this context
     *
     * @return route associated to this context
     */
    Route route();

    /**
     * Get service name associated to this context
     *
     * @return service name associated to this context
     */
    default String service() {
        String svc = params().getOrNull(SearchParam.SERVICE.paramName());
        return svc != null && !svc.isEmpty() ? svc : spLogger().config().indexingQueueName();
    }
}
