package ru.yandex.mail.so.logger;

import java.util.List;
import java.util.Map;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.CgiParams;

public interface LogRecordStorageInfo {
    /**
     * Initializes info from search backend's response.
     *
     * @param jsonMap input JSON map fragment included into answer returned by search backend
     * @return parsed parameters from the map
     * @throws JsonException exception that may be thrown during parsing
     */
    Map<String, List<String>> init(final JsonMap jsonMap) throws JsonException;

    /**
     * Initializes info from ProxySession's params.
     *
     * @param params input CGI-parameters parsing of which fills this object
     * @throws BadRequestException exception that may be thrown during parsing
     */
    //
    void init(final CgiParams params) throws BadRequestException;

    /**
     * Get storage key that log record receives after saving into storage
     * @return storage key that log record receives after saving into storage
     */
    String storageKey();

    /**
     * Get offset that log record receives after adding to the corresponding batch
     * @return offset that log record receives after adding to the corresponding batch
     */
    int offset();

    /**
     * Get size of the log record
     * @return size of the log record
     */
    int logSize();

    /**
     * Get byte offset that log record receives after adding to the corresponding batch
     * @return byte offset that log record receives after adding to the corresponding batch
     */
    int byteOffset();

    /**
     * Get byte size of the log record
     * @return byte size of the log record
     */
    int logBytesSize();
}
