package ru.yandex.mail.so.logger;

import java.util.List;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public interface LogRecordsContext<P extends RoutedLogRecordProducer> extends LogContext {
    int DEFAULT_SEARCH_DOCS_LIMIT = 20;

    /**
     * Get related session object for this context
     *
     * @return related session object for this context
     */
    ProxySession session();

    /**
     * Default implementation of initializing this context by input JSON object
     *
     * @param json input JSON
     * @throws JsonException exception that may be thrown during JSON's parsing
     */
    default void init(final JsonObject json) throws JsonException {
        if (json == null || json.type() == JsonObject.Type.NULL) {
            return;
        }
        if (json.type() == JsonObject.Type.LIST) {
            for (final JsonObject hit : json.asList()) {
                if (hit.type() != JsonObject.Type.MAP) {
                    continue;
                }
                JsonMap jsonMap = hit.asMap();
                if (jsonMap.containsKey(HITS_COUNT) && jsonMap.getLong(HITS_COUNT) == 0) {
                    continue;
                }
                for (JsonObject item : jsonMap.getList(HITS_ARRAY)) {
                    records().add(handlerType().createLogRecordContext(this, item.asMap()));
                }
            }
        } else if (json.type() == JsonObject.Type.MAP) {
            records().add(handlerType().createLogRecordContext(this, json.asMap()));
        }
    }

    /**
     * Get log records with related info (i.e. its "contexts") for this context
     *
     * @return log records with related info (i.e. its "contexts") for this context
     */
    List<P> records();

    /**
     * Get limit of records count for search of log records that is used within this context
     *
     * @return limit of records count for search of log records that is used within this context
     */
    int limit();
}
