package ru.yandex.mail.so.logger;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.mail.so.logger.config.ImmutableLogRecordsHandlerConfig;
import ru.yandex.mail.so.logger.config.LogRecordsHandlerConfig;
import ru.yandex.mail.so.logger.config.LogRecordsHandlerConfigBuilder;
import ru.yandex.mail.so.logger.config.NullLogRecordsHandlerConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum LogRecordsHandlerType {
    NULL {
        @Override
        public LogRecordsHandlerConfig createConfig(final IniConfig config, final LogRecordsHandlerConfig defaults) {
            return NullLogRecordsHandlerConfig.INSTANCE;
        }

        @Override
        public LogRecordContext createLogRecordContext(
            final SpLogger spLogger,
            final ProxySession session,
            final LogStorageType storageType,
            final String logRecord,
            final Route route)
        {
            return new NullLogRecordContext(spLogger, session, storageType, logRecord, route);
        }

        @Override
        public LogRecordContext createLogRecordContext(final LogContext logContext, final JsonMap record) {
            return new NullLogRecordContext(logContext, record);
        }

        @Override
        public LogRecordsContext<LogRecordContext> createLogRecordsContext(
            final SpLogger spLogger,
            final ProxySession session,
            final LogStorageType storageType,
            final Route route)
        {
            return new NullLogRecordsContext(spLogger, session, storageType, route);
        }

        @Override
        public AbstractLogRecordsHandler createHandler(
            final ImmutableLogRecordsHandlerConfig config,
            final SpLogger spLogger,
            final String path)
            throws ConfigException
        {
            return new NullLogRecordsHandler(config, spLogger, path);
        }
    },
    SP_DAEMON {
        @Override
        public LogRecordContext createLogRecordContext(
            final SpLogger spLogger,
            final ProxySession session,
            final LogStorageType storageType,
            final String logRecord,
            final Route route)
        {
            return new DeliveryLogRecordContext(spLogger, session, storageType, logRecord, route);
        }

        @Override
        public LogRecordContext createLogRecordContext(final LogContext logContext, final JsonMap record)
            throws JsonException
        {
            return new DeliveryLogRecordContext(logContext, record);
        }

        @Override
        public LogRecordsContext<LogRecordContext> createLogRecordsContext(
            final SpLogger spLogger,
            final ProxySession session,
            final LogStorageType storageType,
            final Route route)
        {
            return new DeliveryLogRecordsContext(spLogger, session, storageType, route);
        }

        @Override
        public AbstractLogRecordsHandler createHandler(
            final ImmutableLogRecordsHandlerConfig config,
            final SpLogger spLogger,
            final String path)
            throws ConfigException
        {
            return new DeliveryLogRecordsHandler(config, spLogger, path);
        }
    };

    public LogRecordsHandlerConfig createConfig(final IniConfig config, final LogRecordsHandlerConfig defaults)
        throws ConfigException
    {
        ImmutableLogRecordsHandlerConfig mDefaults = null;
        if (defaults instanceof ImmutableLogRecordsHandlerConfig) {
            mDefaults = (ImmutableLogRecordsHandlerConfig) defaults;
        }
        return new LogRecordsHandlerConfigBuilder(config, mDefaults);
    }

    public abstract RoutedLogRecordProducer createLogRecordContext(
        final SpLogger spLogger,
        final ProxySession session,
        final LogStorageType storageType,
        final String logRecord,
        final Route route);

    public abstract <P extends RoutedLogRecordProducer> P createLogRecordContext(
        final LogContext logContext,
        final JsonMap record)
        throws JsonException;

    public abstract LogRecordsContext<LogRecordContext> createLogRecordsContext(
        final SpLogger spLogger,
        final ProxySession session,
        final LogStorageType storageType,
        final Route route);

    public abstract AbstractLogRecordsHandler createHandler(
        final ImmutableLogRecordsHandlerConfig config,
        final SpLogger spLogger,
        final String path)
        throws ConfigException;
}
