package ru.yandex.mail.so.logger;

import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.mail.so.logger.config.LogStorageConfig;

public interface LogStorage<P extends RoutedLogRecordProducer> extends BatchLogSaver<P, LogStorageConfig> {
    /**
     * Get logs basic storage's type: MDS, NULL, etc.
     *
     * @return logs basic storage's type
     */
    @Override
    LogStorageType type();

    /**
     * Async gathering of log records by given its context info
     *
     * @param context info for gathering log records
     * @param callback callback for processing of obtained log records
     */
    void get(
        final LogRecordsContext<P> context,
        final FutureCallback<List<LogRecordsBatch<P, LogStorageConfig>>> callback);

    /**
     * Async removing logs records and related meta data from the storage
     *
     * @param session session in which removing operation will be performed
     * @param callback callback for fixing of result's success
     */
    void remove(final ProxySession session, final FutureCallback<Void> callback);

    /**
     * Get TTl of the log records that will be saving in the storage
     *
     * @return TTl of the log records that will be saving in the storage
     */
    long ttl();

    /**
     * Sets TTl of the log records that will be saving in the storage
     *
     * @param ttl TTl of the log records that will be saving in the storage
     */
    void setTTL(final long ttl);
}
