package ru.yandex.mail.so.logger;

public class LogStorageException extends Exception {
    private static final long serialVersionUID = 0L;
    private static final String IN = " in ";
    private static final String STORAGE = " storage ";

    public LogStorageException() {
    }

    public LogStorageException(final LogStorageType type, final String storageName, final String message)
    {
        super(message + IN + type.name() + STORAGE + storageName);
    }

    public LogStorageException(
        final LogStorageType type,
        final String storageName,
        final String message,
        final Throwable cause)
    {
        super(message + IN + type.name() + STORAGE + storageName, cause);
    }

    public LogStorageException(final Throwable cause) {
        super(cause);
    }

    public LogStorageException(final String message, final Throwable cause) {
        super(message, cause);
    }
}
